
<?php
session_start();
require_once '../db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) header("Location: index.php");

// সেটিংস আপডেট লজিক
if (isset($_POST['update_settings'])) {
    $bkash = $_POST['bkash'];
    $nagad = $_POST['nagad'];
    $notice = $_POST['notice'];
    $min_dep = $_POST['min_deposit'];
    $min_with = $_POST['min_withdraw'];

    $sql = "UPDATE settings SET bkash_number=?, nagad_number=?, notice_text=?, min_deposit=?, min_withdraw=? WHERE id=1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssdd", $bkash, $nagad, $notice, $min_dep, $min_with);
    
    if ($stmt->execute()) {
        echo "<script>alert('Settings Updated Successfully!');</script>";
    }
}

// বর্তমান সেটিংস আনা
$settings = $conn->query("SELECT * FROM settings WHERE id=1")->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Website Settings</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        .settings-form { background: #1E2129; padding: 30px; border-radius: 10px; border: 1px solid #333; max-width: 600px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; color: #B0B3C7; margin-bottom: 5px; }
        input, textarea { width: 100%; padding: 10px; background: #000; border: 1px solid #444; color: #fff; border-radius: 5px; box-sizing: border-box; }
        .save-btn { background: #28a745; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; width: 100%; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo">BOT CLUB ADMIN</div>
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="users.php"><i class="fas fa-users"></i> Users</a></li>
            <li><a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits</a></li>
            <li><a href="withdrawals.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a></li>
            <li><a href="settings.php" class="active"><i class="fas fa-cogs"></i> Settings</a></li>
            <li><a href="logout.php" style="color: #ff4d4d;"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="header"><h2>General Settings</h2></div>

        <div class="settings-form">
            <form method="POST">
                <div class="form-group">
                    <label>Website Notice (Marquee):</label>
                    <textarea name="notice" rows="3"><?php echo $settings['notice_text']; ?></textarea>
                </div>

                <div class="form-group">
                    <label>bKash Personal Number:</label>
                    <input type="text" name="bkash" value="<?php echo $settings['bkash_number']; ?>">
                </div>

                <div class="form-group">
                    <label>Nagad Personal Number:</label>
                    <input type="text" name="nagad" value="<?php echo $settings['nagad_number']; ?>">
                </div>

                <div class="form-group" style="display: flex; gap: 10px;">
                    <div style="flex:1">
                        <label>Min Deposit (৳):</label>
                        <input type="number" name="min_deposit" value="<?php echo $settings['min_deposit']; ?>">
                    </div>
                    <div style="flex:1">
                        <label>Min Withdraw (৳):</label>
                        <input type="number" name="min_withdraw" value="<?php echo $settings['min_withdraw']; ?>">
                    </div>
                </div>

                <button type="submit" name="update_settings" class="save-btn">Save Changes</button>
            </form>
        </div>
    </div>
</body>
</html>